/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bukkit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.stream.Collectors;
import net.skinsrestorer.api.PlayerWrapper;
import net.skinsrestorer.api.SkinsRestorerAPI;
import net.skinsrestorer.api.exception.SkinRequestException;
import net.skinsrestorer.api.interfaces.IPropertyFactory;
import net.skinsrestorer.api.interfaces.ISRPlayer;
import net.skinsrestorer.api.property.GenericProperty;
import net.skinsrestorer.api.property.IProperty;
import net.skinsrestorer.api.reflection.ReflectionUtil;
import net.skinsrestorer.api.serverinfo.ServerVersion;
import net.skinsrestorer.bukkit.SkinApplierBukkit;
import net.skinsrestorer.bukkit.SkinsGUI;
import net.skinsrestorer.bukkit.commands.GUICommand;
import net.skinsrestorer.bukkit.commands.SkinCommand;
import net.skinsrestorer.bukkit.commands.SrCommand;
import net.skinsrestorer.bukkit.listener.InventoryListener;
import net.skinsrestorer.bukkit.listener.PlayerJoin;
import net.skinsrestorer.bukkit.listener.PlayerResourcePackStatus;
import net.skinsrestorer.bukkit.listener.ProtocolLibJoinListener;
import net.skinsrestorer.bukkit.utils.BukkitConsoleImpl;
import net.skinsrestorer.bukkit.utils.BukkitProperty;
import net.skinsrestorer.bukkit.utils.NoMappingException;
import net.skinsrestorer.bukkit.utils.UpdateDownloaderGithub;
import net.skinsrestorer.bukkit.utils.WrapperBukkit;
import net.skinsrestorer.paper.PaperUtil;
import net.skinsrestorer.shadow.aikar.commands.PaperCommandManager;
import net.skinsrestorer.shadow.bstats.bukkit.Metrics;
import net.skinsrestorer.shadow.bstats.charts.SingleLineChart;
import net.skinsrestorer.shadow.paperlib.PaperLib;
import net.skinsrestorer.shadow.spiget.UpdateCallback;
import net.skinsrestorer.shared.exception.InitializeException;
import net.skinsrestorer.shared.interfaces.ISRPlugin;
import net.skinsrestorer.shared.storage.Config;
import net.skinsrestorer.shared.storage.Locale;
import net.skinsrestorer.shared.storage.SkinStorage;
import net.skinsrestorer.shared.storage.YamlConfig;
import net.skinsrestorer.shared.update.UpdateChecker;
import net.skinsrestorer.shared.update.UpdateCheckerGitHub;
import net.skinsrestorer.shared.utils.MetricsCounter;
import net.skinsrestorer.shared.utils.SharedMethods;
import net.skinsrestorer.shared.utils.WrapperFactory;
import net.skinsrestorer.shared.utils.connections.MineSkinAPI;
import net.skinsrestorer.shared.utils.connections.MojangAPI;
import net.skinsrestorer.shared.utils.log.JavaLoggerImpl;
import net.skinsrestorer.shared.utils.log.SRLogger;
import net.skinsrestorer.spigot.SpigotUtil;
import net.skinsrestorer.v1_7.BukkitLegacyProperty;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SkinsRestorer
extends JavaPlugin
implements ISRPlugin {
    private final MetricsCounter metricsCounter = new MetricsCounter();
    private final BukkitConsoleImpl bukkitConsole = new BukkitConsoleImpl(this.getServer() == null ? null : this.getServer().getConsoleSender());
    private final JavaLoggerImpl javaLogger = new JavaLoggerImpl(this.bukkitConsole, this.getServer() == null ? null : this.getServer().getLogger());
    private final SRLogger srLogger = new SRLogger(this.javaLogger, true);
    private final MojangAPI mojangAPI = new MojangAPI(this.srLogger, this.metricsCounter);
    private final MineSkinAPI mineSkinAPI = new MineSkinAPI(this.srLogger, this.metricsCounter);
    private final SkinStorage skinStorage = new SkinStorage(this.srLogger, this.mojangAPI, this.mineSkinAPI);
    private final UpdateChecker updateChecker = new UpdateCheckerGitHub(2124, this.getVersion(), this.srLogger, "SkinsRestorerUpdater/Bukkit");
    private final SkinsRestorerAPI skinsRestorerAPI = new SkinsRestorerBukkitAPI();
    private final UpdateDownloaderGithub updateDownloader = new UpdateDownloaderGithub(this);
    private final SkinCommand skinCommand = new SkinCommand(this);
    private Path dataFolderPath;
    private SkinApplierBukkit skinApplierBukkit;
    private boolean proxyMode;
    private boolean updateDownloaded = false;
    private PaperCommandManager manager;
    private boolean isUpdaterInitialized = false;

    private static Map<String, GenericProperty> convertToObject(byte[] byteArr) {
        Map<String, GenericProperty> map = new TreeMap<String, GenericProperty>();
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(byteArr);
            ObjectInputStream ois = new ObjectInputStream(bis);
            while (bis.available() > 0) {
                map = (Map)ois.readObject();
            }
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
        }
        return map;
    }

    @Override
    public String getVersion() {
        return this.getDescription() == null ? null : this.getDescription().getVersion();
    }

    @Override
    public void runAsync(Runnable runnable) {
        this.getServer().getScheduler().runTaskAsynchronously((Plugin)this, runnable);
    }

    @Override
    public Collection<ISRPlayer> getOnlinePlayers() {
        return this.getServer().getOnlinePlayers().stream().map(WrapperBukkit::wrapPlayer).collect(Collectors.toList());
    }

    public void onEnable() {
        this.bukkitConsole.setConsoleCommandSender(this.getServer().getConsoleSender());
        this.javaLogger.setLogger(this.getServer().getLogger());
        this.dataFolderPath = this.getDataFolder().toPath();
        this.updateChecker.setCurrentVersion(this.getVersion());
        this.srLogger.load(this.dataFolderPath);
        Exception startupError = null;
        try {
            this.pluginStartup();
        }
        catch (Exception e) {
            startupError = e;
        }
        finally {
            if (!this.isUpdaterInitialized) {
                this.updateCheck();
            }
        }
        if (startupError != null) {
            this.srLogger.debug("An error occurred while starting the plugin.", startupError);
        }
    }

    public void pluginStartup() throws InitializeException {
        Metrics metrics = new Metrics(this, 1669);
        metrics.addCustomChart(new SingleLineChart("mineskin_calls", this.metricsCounter::collectMineskinCalls));
        metrics.addCustomChart(new SingleLineChart("minetools_calls", this.metricsCounter::collectMinetoolsCalls));
        metrics.addCustomChart(new SingleLineChart("mojang_calls", this.metricsCounter::collectMojangCalls));
        metrics.addCustomChart(new SingleLineChart("ashcon_calls", this.metricsCounter::collectAshconCalls));
        try {
            this.skinApplierBukkit = new SkinApplierBukkit(this, this.srLogger);
        }
        catch (NoMappingException e) {
            this.srLogger.severe("Your Minecraft version is not supported by this version of SkinsRestorer! Is there a newer version available? If not, join our discord server!", e);
            throw e;
        }
        catch (InitializeException e) {
            this.srLogger.severe(ChatColor.RED + ChatColor.UNDERLINE.toString() + "Could not initialize SkinApplier! Please report this on our discord server!");
            throw e;
        }
        this.srLogger.info(ChatColor.GREEN + "Detected Minecraft " + ChatColor.YELLOW + ReflectionUtil.SERVER_VERSION_STRING + ChatColor.GREEN + ", using " + ChatColor.YELLOW + this.skinApplierBukkit.getRefresh().getClass().getSimpleName() + ChatColor.GREEN + ".");
        if (ReflectionUtil.SERVER_VERSION != null && !ReflectionUtil.SERVER_VERSION.isNewer(new ServerVersion(1, 7, 10))) {
            this.srLogger.warning(ChatColor.YELLOW + "Although SkinsRestorer allows using this ancient version, we will not provide full support for it. This version of Minecraft does not allow using all of SkinsRestorers features due to client side restrictions. Please be aware things WILL BREAK and not work!");
        }
        if (this.getServer().getPluginManager().getPlugin("ViaVersion") != null && !ReflectionUtil.classExists("com.viaversion.viaversion.api.Via")) {
            this.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this, () -> this.srLogger.severe("Outdated ViaVersion found! Please update to at least ViaVersion 4.0.0 for SkinsRestorer to work again!"), 50L, 1200L);
        }
        if (this.getServer().getPluginManager().getPlugin("MundoSK") != null) {
            try {
                YamlConfig mundoConfig = new YamlConfig(this.dataFolderPath.getParent().resolve("MundoSK").resolve("config.yml"));
                mundoConfig.load();
                if (mundoConfig.getBoolean("enable_custom_skin_and_tablist").booleanValue()) {
                    this.srLogger.warning(ChatColor.DARK_RED + "----------------------------------------------");
                    this.srLogger.warning(ChatColor.DARK_RED + "             [CRITICAL WARNING]");
                    this.srLogger.warning(ChatColor.RED + "We have detected MundoSK on your server with " + ChatColor.YELLOW + "'enable_custom_skin_and_tablist: " + ChatColor.DARK_RED + ChatColor.UNDERLINE + "true" + ChatColor.YELLOW + "' " + ChatColor.RED + ".");
                    this.srLogger.warning(ChatColor.RED + "That setting is located in \u00a7e/plugins/MundoSK/config.yml");
                    this.srLogger.warning(ChatColor.RED + "You have to disable ('false') it to get SkinsRestorer to work!");
                    this.srLogger.warning(ChatColor.DARK_RED + "----------------------------------------------");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.checkProxyMode();
        this.updateCheck();
        Bukkit.getPluginManager().registerEvents((Listener)new InventoryListener(), (Plugin)this);
        if (this.proxyMode) {
            Bukkit.getMessenger().registerOutgoingPluginChannel((Plugin)this, "sr:skinchange");
            Bukkit.getMessenger().registerIncomingPluginChannel((Plugin)this, "sr:skinchange", (channel, player, message) -> {
                if (!channel.equals("sr:skinchange")) {
                    return;
                }
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, () -> {
                    block4: {
                        DataInputStream in = new DataInputStream(new ByteArrayInputStream(message));
                        try {
                            String subChannel = in.readUTF();
                            if (!subChannel.equalsIgnoreCase("SkinUpdate")) break block4;
                            try {
                                this.skinsRestorerAPI.applySkin(new PlayerWrapper(player), SkinsRestorerAPI.getApi().createPlatformProperty(in.readUTF(), in.readUTF(), in.readUTF()));
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            this.skinApplierBukkit.updateSkin(player);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            });
            Bukkit.getMessenger().registerOutgoingPluginChannel((Plugin)this, "sr:messagechannel");
            Bukkit.getMessenger().registerIncomingPluginChannel((Plugin)this, "sr:messagechannel", (channel, channelPlayer, message) -> {
                if (!channel.equals("sr:messagechannel")) {
                    return;
                }
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, () -> {
                    DataInputStream in = new DataInputStream(new ByteArrayInputStream(message));
                    try {
                        Player player;
                        String subChannel = in.readUTF();
                        if (subChannel.equalsIgnoreCase("OPENGUI")) {
                            player = Bukkit.getPlayer((String)in.readUTF());
                            if (player == null) {
                                return;
                            }
                            this.requestSkinsFromBungeeCord(player, 0);
                        }
                        if (subChannel.equalsIgnoreCase("returnSkins")) {
                            player = Bukkit.getPlayer((String)in.readUTF());
                            if (player == null) {
                                return;
                            }
                            int page = in.readInt();
                            short len = in.readShort();
                            byte[] msgBytes = new byte[len];
                            in.readFully(msgBytes);
                            Map<String, GenericProperty> skinList = SkinsRestorer.convertToObject(msgBytes);
                            TreeMap<String, IProperty> newSkinList = new TreeMap<String, IProperty>();
                            skinList.forEach((name, property) -> newSkinList.put((String)name, SkinsRestorerAPI.getApi().createPlatformProperty(property.getName(), property.getValue(), property.getSignature())));
                            Inventory inventory = SkinsGUI.createGUI(this, page, newSkinList);
                            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this, () -> player.openInventory(inventory));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            });
        } else {
            Config.load(this.dataFolderPath, this.getResource("config.yml"), this.srLogger);
            Locale.load(this.dataFolderPath, this.srLogger);
            if (!this.initStorage()) {
                return;
            }
            this.initCommands();
            if (!Config.ENABLE_PROTOCOL_LISTENER || Bukkit.getPluginManager().getPlugin("ProtocolLib") == null) {
                Bukkit.getPluginManager().registerEvents((Listener)new PlayerJoin(this), (Plugin)this);
                if (ReflectionUtil.classExists("org.bukkit.event.player.PlayerResourcePackStatusEvent")) {
                    Bukkit.getPluginManager().registerEvents((Listener)new PlayerResourcePackStatus(this), (Plugin)this);
                }
            } else {
                this.srLogger.info("Hooking into ProtocolLib for instant skins on join!");
                new ProtocolLibJoinListener(this);
            }
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, () -> SharedMethods.runServiceCheck(this.mojangAPI, this.srLogger));
        }
    }

    private void updateCheck() {
        this.isUpdaterInitialized = true;
        Path updaterDisabled = this.dataFolderPath.resolve("noupdate.txt");
        if (!Files.exists(updaterDisabled, new LinkOption[0])) {
            this.checkUpdate(this.proxyMode, true);
            int delayInt = 300 + new Random().nextInt(1501);
            int periodInt = 60 + new Random().nextInt(181);
            this.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this, () -> this.checkUpdate(this.proxyMode, false), 20L * (long)delayInt, 1200L * (long)periodInt);
        } else {
            this.srLogger.info("Updater Disabled");
        }
    }

    public void requestSkinsFromBungeeCord(Player player, int page) {
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(bytes);
            out.writeUTF("getSkins");
            out.writeUTF(player.getName());
            out.writeInt(page);
            player.sendPluginMessage((Plugin)this, "sr:messagechannel", bytes.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void requestSkinClearFromBungeeCord(Player player) {
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(bytes);
            out.writeUTF("clearSkin");
            out.writeUTF(player.getName());
            player.sendPluginMessage((Plugin)this, "sr:messagechannel", bytes.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void requestSkinSetFromBungeeCord(Player player, String skin) {
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(bytes);
            out.writeUTF("setSkin");
            out.writeUTF(player.getName());
            out.writeUTF(skin);
            player.sendPluginMessage((Plugin)this, "sr:messagechannel", bytes.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void initCommands() {
        this.manager = new PaperCommandManager((Plugin)this);
        this.prepareACF(this.manager, this.srLogger);
        this.manager.registerCommand(this.skinCommand);
        this.manager.registerCommand(new SrCommand(this));
        this.manager.registerCommand(new GUICommand(this));
    }

    private boolean initStorage() {
        if (!SharedMethods.initStorage(this.srLogger, this.skinStorage, this.dataFolderPath)) {
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return false;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, this.skinStorage::preloadDefaultSkins);
        return true;
    }

    private void checkProxyMode() {
        this.proxyMode = false;
        try {
            if (PaperLib.isSpigot()) {
                this.proxyMode = SpigotUtil.getSpigotConfig(this.getServer()).getBoolean("settings.bungeecord");
            }
            Path spigotFile = Paths.get("spigot.yml", new String[0]);
            if (!this.proxyMode && Files.exists(spigotFile, new LinkOption[0])) {
                this.proxyMode = YamlConfiguration.loadConfiguration((File)spigotFile.toFile()).getBoolean("settings.bungeecord");
            }
            if (PaperLib.isPaper()) {
                YamlConfiguration config;
                Path oldPaperFile = Paths.get("paper.yml", new String[0]);
                if (!this.proxyMode && Files.exists(oldPaperFile, new LinkOption[0])) {
                    this.proxyMode = YamlConfiguration.loadConfiguration((File)oldPaperFile.toFile()).getBoolean("settings.velocity-support.enabled");
                }
                if ((config = PaperUtil.getPaperConfig(this.getServer())) != null && !this.proxyMode && (config.getBoolean("settings.velocity-support.enabled") || config.getBoolean("proxies.velocity.enabled"))) {
                    this.proxyMode = true;
                }
            }
            Path bungeeModeEnabled = this.dataFolderPath.resolve("enableBungeeMode");
            Path bungeeModeDisabled = this.dataFolderPath.resolve("disableBungeeMode");
            Path proxyModeEnabled = this.dataFolderPath.resolve("enableProxyMode.txt");
            Path proxyModeDisabled = this.dataFolderPath.resolve("disableProxyMode.txt");
            if (Files.exists(bungeeModeEnabled, new LinkOption[0])) {
                Files.move(bungeeModeEnabled, proxyModeEnabled, StandardCopyOption.REPLACE_EXISTING);
            } else if (Files.exists(bungeeModeDisabled, new LinkOption[0])) {
                Files.move(bungeeModeDisabled, proxyModeDisabled, StandardCopyOption.REPLACE_EXISTING);
            }
            if (!this.proxyMode && Files.exists(proxyModeEnabled, new LinkOption[0])) {
                this.proxyMode = true;
                return;
            }
            if (Files.exists(proxyModeDisabled, new LinkOption[0])) {
                this.proxyMode = false;
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        StringBuilder sb1 = new StringBuilder("Server is in proxy mode!");
        sb1.append("\nif you are NOT using BungeeCord in your network, set spigot.yml -> bungeecord: false");
        sb1.append("\n\nInstallation for BungeeCord:");
        sb1.append("\nDownload the latest version from https://www.spigotmc.org/resources/skinsrestorer.2124/");
        sb1.append("\nPlace the SkinsRestorer.jar in ./plugins/ folders of every Spigot server.");
        sb1.append("\nPlace the plugin in ./plugins/ folder of every BungeeCord server.");
        sb1.append("\nCheck & set on every Spigot server spigot.yml -> bungeecord: true");
        sb1.append("\nRestart (/restart or /stop) all servers [Plugman or /reload are NOT supported, use /stop or /end]");
        sb1.append("\n\nBungeeCord now has SkinsRestorer installed with the Spigot integration!");
        sb1.append("\nYou may now configure SkinsRestorer on BungeeCord (BungeeCord plugins folder /plugins/SkinsRestorer)");
        Path warning = this.dataFolderPath.resolve("(README) Use proxy config for settings! (README)");
        try {
            if (this.proxyMode && !Files.exists(warning, new LinkOption[0])) {
                Files.createDirectories(warning.getParent(), new FileAttribute[0]);
                Files.write(warning, String.valueOf(sb1).getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            }
            if (!this.proxyMode) {
                Files.deleteIfExists(warning);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.proxyMode) {
            this.srLogger.info("-------------------------/Warning\\-------------------------");
            this.srLogger.info("This plugin is running in PROXY mode!");
            this.srLogger.info("You have to do all configuration at config file");
            this.srLogger.info("inside your BungeeCord/Velocity server.");
            this.srLogger.info("(BungeeCord-Server/plugins/SkinsRestorer/)");
            this.srLogger.info("-------------------------\\Warning/-------------------------");
        }
    }

    private void checkUpdate(final boolean proxyMode, final boolean showUpToDate) {
        this.runAsync(() -> this.updateChecker.checkForUpdate(new UpdateCallback(){

            @Override
            public void updateAvailable(String newVersion, String downloadUrl, boolean hasDirectDownload) {
                if (SkinsRestorer.this.updateDownloaded) {
                    return;
                }
                String failReason = null;
                if (hasDirectDownload) {
                    if (SkinsRestorer.this.updateDownloader.downloadUpdate()) {
                        SkinsRestorer.this.updateDownloaded = true;
                    } else {
                        failReason = SkinsRestorer.this.updateDownloader.getFailReason().toString();
                    }
                }
                SkinsRestorer.this.updateChecker.getUpdateAvailableMessages(newVersion, downloadUrl, hasDirectDownload, SkinsRestorer.this.getVersion(), proxyMode, true, failReason).forEach(SkinsRestorer.this.srLogger::info);
            }

            @Override
            public void upToDate() {
                if (!showUpToDate) {
                    return;
                }
                SkinsRestorer.this.updateChecker.getUpToDateMessages(SkinsRestorer.this.getVersion(), proxyMode).forEach(SkinsRestorer.this.srLogger::info);
            }
        }));
    }

    @Override
    public MetricsCounter getMetricsCounter() {
        return this.metricsCounter;
    }

    public BukkitConsoleImpl getBukkitConsole() {
        return this.bukkitConsole;
    }

    public JavaLoggerImpl getJavaLogger() {
        return this.javaLogger;
    }

    @Override
    public SRLogger getSrLogger() {
        return this.srLogger;
    }

    @Override
    public MojangAPI getMojangAPI() {
        return this.mojangAPI;
    }

    public MineSkinAPI getMineSkinAPI() {
        return this.mineSkinAPI;
    }

    @Override
    public SkinStorage getSkinStorage() {
        return this.skinStorage;
    }

    public UpdateChecker getUpdateChecker() {
        return this.updateChecker;
    }

    public SkinsRestorerAPI getSkinsRestorerAPI() {
        return this.skinsRestorerAPI;
    }

    public UpdateDownloaderGithub getUpdateDownloader() {
        return this.updateDownloader;
    }

    @Override
    public SkinCommand getSkinCommand() {
        return this.skinCommand;
    }

    @Override
    public Path getDataFolderPath() {
        return this.dataFolderPath;
    }

    public SkinApplierBukkit getSkinApplierBukkit() {
        return this.skinApplierBukkit;
    }

    public boolean isProxyMode() {
        return this.proxyMode;
    }

    public boolean isUpdateDownloaded() {
        return this.updateDownloaded;
    }

    public PaperCommandManager getManager() {
        return this.manager;
    }

    public boolean isUpdaterInitialized() {
        return this.isUpdaterInitialized;
    }

    private class SkinsRestorerBukkitAPI
    extends SkinsRestorerAPI {
        public SkinsRestorerBukkitAPI() {
            super(SkinsRestorer.this.mojangAPI, SkinsRestorer.this.mineSkinAPI, SkinsRestorer.this.skinStorage, new WrapperFactoryBukkit(), new PropertyFactoryBukkit());
        }

        @Override
        public void applySkin(PlayerWrapper playerWrapper) throws SkinRequestException {
            this.applySkin(playerWrapper, playerWrapper.get(Player.class).getName());
        }

        @Override
        public void applySkin(PlayerWrapper playerWrapper, String playerName) throws SkinRequestException {
            this.applySkin(playerWrapper, SkinsRestorer.this.skinStorage.getSkinForPlayer(playerName));
        }

        @Override
        public void applySkin(PlayerWrapper playerWrapper, IProperty property) {
            SkinsRestorer.this.skinApplierBukkit.applySkin(playerWrapper.get(Player.class), property);
        }
    }

    private static class PropertyFactoryBukkit
    implements IPropertyFactory {
        private PropertyFactoryBukkit() {
        }

        @Override
        public IProperty createProperty(String name, String value, String signature) {
            if (ReflectionUtil.classExists("com.mojang.authlib.properties.Property")) {
                return new BukkitProperty(name, value, signature);
            }
            return new BukkitLegacyProperty(name, value, signature);
        }
    }

    private static class WrapperFactoryBukkit
    extends WrapperFactory {
        private WrapperFactoryBukkit() {
        }

        @Override
        public ISRPlayer wrapPlayer(Object playerInstance) {
            if (playerInstance instanceof Player) {
                Player player = (Player)playerInstance;
                return WrapperBukkit.wrapPlayer(player);
            }
            throw new IllegalArgumentException("Player instance is not valid!");
        }
    }
}

